<?php
declare(strict_types = 1);

namespace IssetBV\FixtureBundle\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class FixtureCompilerPass
 * @package IssetBV\FixtureBundle\Compiler
 */
class FixtureCompilerPass implements CompilerPassInterface
{

    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $tag = 'isset_bv_fixture.container';
        if (!$container->hasDefinition($tag)) {
            return;
        }
        $definition = $container->getDefinition($tag);
        $taggedServices = $container->findTaggedServiceIds('isset_bv_fixture');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', array(
                new Reference($id)
            ));
        }
    }
}