<?php
declare(strict_types = 1);

namespace IssetBV\FixtureBundle\Service;

use Doctrine\ORM\EntityManagerInterface;

/**
 * Interface FixtureInterface
 * @package IssetBV\FixtureBundle\Service
 */
interface FixtureInterface
{

    /**
     * @param EntityManagerInterface $entityManager
     */
    public function handle(EntityManagerInterface $entityManager);

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return int
     */
    public function getWeight(): int;

    /**
     * @return array
     */
    public function getGroups(): array;

}