<?php
declare(strict_types = 1);

namespace IssetBV\FixtureBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class FixtureCommand
 * @package IssetBV\FixtureBundle\Command
 */
class FixtureCommand extends ContainerAwareCommand
{

    /**
     * @return void
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('isset_bv:fixture');
        $this->addArgument('name');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|null|void
     * @throws \LogicException
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceCircularReferenceException
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $handler = $this->getContainer()->get('isset_bv_fixture.handler');
        if ($input->getArgument('name') !== null) {
            $handler->runByName($input->getArgument('name'));
        } else {
            $handler->run();
        }
    }

    /**
     * @param OutputInterface $output
     * @param string $text
     */
    public function writeln(OutputInterface $output, string $text)
    {
        if (!$output->isQuiet()) {
            $output->writeln($text);
        }
    }
}