<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Controller;

use IssetBV\ErrorBundle\Service\Generator\ErrorGenerator;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

/**
 * Class DocsController.
 */
class DocsController extends Controller
{
    /**
     * @var ErrorGenerator
     */
    private $errorGenerator;

    public function __construct(ErrorGenerator $errorGenerator)
    {
        $this->errorGenerator = $errorGenerator;
    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $errors = $this->errorGenerator->getErrorLoader()->loadAll();

        return $this->render('@IssetBVError/Docs/Errors.html.twig', ['errors' => $errors]);
    }
}
