<?php
declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator\Data;

use IssetBV\FormBundle\Service\Error\FormData;
use IssetBV\FormBundle\Service\Error\FormDataError;
use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationList;

class ConstraintDataConverter implements DataConverter
{
    /**
     * @param $data
     *
     * @return ConstraintViolationList
     */
    public function convert($data)
    {
        $formData = new FormData(false, '');
        /** @var ConstraintViolationList $data */
        /** @var ConstraintViolation $error */
        foreach ($data as $error) {
            $subFormData = new FormData(false, $error->getPropertyPath());
            $subFormData->addError($this->convertFormConstraint($error));
            $formData->addField($error->getPropertyPath(), $subFormData);
        }

        return $formData;
    }


    /**
     * @param ConstraintViolation $constraintViolation
     *
     * @return FormDataError
     */
    public function convertFormConstraint(ConstraintViolation $constraintViolation): FormDataError
    {
        return new FormDataError(
            $constraintViolation->getCode(),
            $constraintViolation->getInvalidValue(),
            $constraintViolation->getMessage()
        );
    }

    /**
     * @param $data
     *
     * @return bool
     */
    public function handles($data): bool
    {
        return $data instanceof ConstraintViolationList;
    }
}
