<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service;

/**
 * Class ErrorImpl.
 */
class ErrorImpl implements Error
{
    /**
     * @var int
     */
    private $code;
    /**
     * @var string
     */
    private $message;
    /**
     * @var string
     */
    private $description;
    /**
     * @var int
     */
    private $httpCode;

    /**
     * ErrorImpl constructor.
     *
     * @param int $code
     * @param string $message
     * @param string $description
     * @param int $httpCode
     */
    public function __construct(int $code, string $message, string $description, int $httpCode)
    {
        $this->code = $code;
        $this->message = $message;
        $this->description = $description;
        $this->httpCode = $httpCode;
    }

    public static function __set_state($array)
    {
        return new self($array['code'], $array['message'], $array['description'], $array['httpCode']);
    }

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return int
     */
    public function getHttpCode(): int
    {
        return $this->httpCode;
    }
}
