<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator;

use IssetBV\ErrorBundle\Service\Loader\ErrorLoader;

/**
 * Interface ErrorGenerator.
 */
interface ErrorGenerator
{
    /**
     * @param string $error
     * @param mixed $data
     *
     * @return mixed
     */
    public function generate(string $error, $data = null);

    /**
     * @return ErrorLoader
     */
    public function getErrorLoader(): ErrorLoader;
}
