<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\DependencyInjection\Compiler;

use IssetBV\ErrorBundle\Service\Generator\Data\DataConverterContainer;
use LogicException;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class StatisticGenerateCompilerPass.
 */
class GeneratorDataConverterCompilerPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     * @throws \LogicException
     */
    public function process(ContainerBuilder $container)
    {
        $tag = DataConverterContainer::class;
        if (!$container->hasDefinition($tag)) {
            throw new LogicException('tag not found ' . $tag);
        }
        $definition = $container->getDefinition($tag);

        $taggedServices = $container->findTaggedServiceIds(DataConverterContainer::TAG);
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('addDataConverter', [
                new Reference($id),
            ]);
        }
    }
}
