<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Loader;

use IssetBV\ErrorBundle\Service\Error;
use IssetBV\ErrorBundle\Service\Loader\Exception\ErrorMissingException;
use IssetBV\ErrorBundle\Service\Loader\Provider\ErrorProvider;

/**
 * Class NoCache.
 */
class NoCache implements ErrorLoader
{
    /**
     * @var Error[]|null
     */
    private $errors;
    /**
     * @var ErrorProvider
     */
    private $errorProvider;

    /**
     * NoCache constructor.
     *
     * @param ErrorProvider $errorProvider
     */
    public function __construct(ErrorProvider $errorProvider)
    {
        $this->errorProvider = $errorProvider;
    }

    /**
     * @return Error[]
     */
    public function loadAll(): array
    {
        if (null === $this->errors) {
            $this->errors = $this->errorProvider->getErrors();
        }

        return $this->errors;
    }

    /**
     * @param string $error
     *
     * @throws ErrorMissingException
     *
     * @return Error
     */
    public function load(string $error): Error
    {
        $errors = $this->loadAll();
        if (!array_key_exists($error, $errors)) {
            throw new ErrorMissingException($error);
        }

        return $this->errors[$error];
    }

    public function clearCache()
    {
        $this->errors = null;
    }
}
