<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\DependencyInjection;

use IssetBV\ErrorBundle\Service\Generator\Data\DataConverterContainer;
use IssetBV\ErrorBundle\Service\Generator\Data\DataConverterContainerImpl;
use IssetBV\ErrorBundle\Service\Generator\Data\DefaultDataConverter;
use IssetBV\ErrorBundle\Service\Generator\ErrorGenerator;
use IssetBV\ErrorBundle\Service\Generator\ErrorGeneratorImpl;
use IssetBV\ErrorBundle\Service\Generator\View\FOSRestViewGenerator;
use IssetBV\ErrorBundle\Service\Generator\View\JsonResponseGenerator;
use IssetBV\ErrorBundle\Service\Generator\View\ViewGenerator;
use IssetBV\ErrorBundle\Service\Loader\ErrorLoader;
use IssetBV\ErrorBundle\Service\Loader\FileCache;
use IssetBV\ErrorBundle\Service\Loader\NoCache;
use IssetBV\ErrorBundle\Service\Loader\Provider\ErrorProvider;
use IssetBV\ErrorBundle\Service\Loader\Provider\YamlErrorProvider;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVErrorExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $definition = $container->register(ErrorGenerator::class, ErrorGeneratorImpl::class);
        $definition->setAutowired(true);
        $definition->setLazy(true);

        $this->setErrorProvider($container);

        $definition = $container->register(NoCache::class, NoCache::class);
        $definition->setAutowired(true);

        $definition = $container->register(FileCache::class, FileCache::class);
        $definition->addArgument(new Reference(ErrorProvider::class));
        $definition->addArgument('%isset_bv.error.loader.file_cache.path%');

        switch ($config['error_generator_loader']) {
            case 'no_cache':
                $container->setAlias(ErrorLoader::class, NoCache::class);
                break;
            case 'file_cache':
                $container->setAlias(ErrorLoader::class, FileCache::class);
                break;
            default:
                $container->setAlias(ErrorLoader::class, $config['error_generator_loader']);
        }

        if (null === $config['error_generator_data_converter_container']) {
            $container->register(DataConverterContainer::class, DataConverterContainerImpl::class);
        }

        $container->register(JsonResponseGenerator::class, JsonResponseGenerator::class);
        $container->register(FOSRestViewGenerator::class, FOSRestViewGenerator::class);

        switch ($config['error_generator_view_generator']) {
            case 'fos_rest':
                $container->setAlias(ViewGenerator::class, FOSRestViewGenerator::class);
                break;
            case 'json_response':
                $container->setAlias(ViewGenerator::class, JsonResponseGenerator::class);
                break;
        }

        $definition = $container->register(DefaultDataConverter::class, DefaultDataConverter::class);
        $definition->addTag(DataConverterContainer::TAG);
    }

    private function setErrorProvider(ContainerBuilder $container)
    {
        $definition = $container->register(YamlErrorProvider::class, YamlErrorProvider::class);
        $definition->addArgument('%kernel.root_dir%');

        if (!$container->hasDefinition(ErrorProvider::class)) {
            $container->setAlias(ErrorProvider::class, YamlErrorProvider::class);
        }
    }
}
