<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator\View;

use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Class JsonResponseGenerator.
 */
class JsonResponseGenerator implements ViewGenerator
{
    /**
     * @param $viewData
     * @param int $httpCode
     *
     * @return JsonResponse
     */
    public function generate($viewData, int $httpCode)
    {
        return new JsonResponse($viewData, $httpCode);
    }
}
