<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator;

use IssetBV\ErrorBundle\Service\Generator\Data\DataConverterContainer;
use IssetBV\ErrorBundle\Service\Generator\Data\Exception\DataConverterNotFound;
use IssetBV\ErrorBundle\Service\Generator\View\ViewGenerator;
use IssetBV\ErrorBundle\Service\Loader\ErrorLoader;
use IssetBV\ErrorBundle\Service\Loader\Exception\ErrorMissingException;

/**
 * Class ErrorGeneratorImpl.
 */
class ErrorGeneratorImpl implements ErrorGenerator
{
    /**
     * @var ViewGenerator
     */
    private $viewGenerator;
    /**
     * @var ErrorLoader
     */
    private $errorLoader;
    /**
     * @var DataConverterContainer
     */
    private $dataConverterContainer;

    /**
     * ErrorGeneratorImpl constructor.
     *
     * @param ErrorLoader $errorLoader
     * @param ViewGenerator $viewGenerator
     * @param DataConverterContainer $dataConverterContainer
     */
    public function __construct(ErrorLoader $errorLoader, ViewGenerator $viewGenerator, DataConverterContainer $dataConverterContainer)
    {
        $this->viewGenerator = $viewGenerator;
        $this->errorLoader = $errorLoader;
        $this->dataConverterContainer = $dataConverterContainer;
    }

    /**
     * @return ErrorLoader
     */
    public function getErrorLoader(): ErrorLoader
    {
        return $this->errorLoader;
    }

    /**
     * @param string $error
     * @param mixed $data
     *
     * @throws DataConverterNotFound
     * @throws ErrorMissingException
     *
     * @return mixed
     */
    public function generate(string $error, $data = null)
    {
        $errorData = $this->errorLoader->load($error);
        $viewData = [
            'code' => $errorData->getCode(),
            'message' => $errorData->getMessage(),
            'data' => $data ? $this->dataConverterContainer->getForData($data)->convert($data) : null,
        ];

        return $this->viewGenerator->generate($viewData, $errorData->getHttpCode());
    }
}
