<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator\Data;

use IssetBV\ErrorBundle\Service\Generator\Data\Exception\DataConverterNotFound;

/**
 * Class DataConverterContainerImpl.
 */
class DataConverterContainerImpl implements DataConverterContainer
{
    /**
     * @var DataConverter[]
     */
    private $converters = [];

    /**
     * @param $data
     *
     * @throws DataConverterNotFound
     *
     * @return DataConverter
     */
    public function getForData($data): DataConverter
    {
        foreach ($this->converters as $converter) {
            if ($converter->handles($data)) {
                return $converter;
            }
        }

        $ex = new DataConverterNotFound();
        $ex->setData($data);
        throw $ex;
    }

    /**
     * @param DataConverter $dataConverter
     */
    public function addDataConverter(DataConverter $dataConverter)
    {
        $this->converters[] = $dataConverter;
    }
}
