<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator\Data;

use IssetBV\ErrorBundle\Service\Generator\Data\Exception\DataConverterNotFound;

interface DataConverterContainer
{
    CONST TAG = 'error.generator.data_converter';

    /**
     * @param $data
     *
     * @throws DataConverterNotFound
     *
     * @return DataConverter
     */
    public function getForData($data): DataConverter;

    /**
     * @param DataConverter $dataConverter
     */
    public function addDataConverter(DataConverter $dataConverter);
}
