<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Loader;

use IssetBV\ErrorBundle\Service\Error;
use IssetBV\ErrorBundle\Service\Loader\Exception\ErrorMissingException;

/**
 * Interface ErrorLoader.
 */
interface ErrorLoader
{
    /**
     * @return Error[]
     */
    public function loadAll(): array;

    /**
     * @param string $error
     *
     * @throws ErrorMissingException
     *
     * @return Error
     */
    public function load(string $error): Error;
}
