<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\Service\Generator\Data;

use IssetBV\FormBundle\Service\Error\FormConverter;
use Symfony\Component\Form\FormInterface;

/**
 * Class FormDataConverter.
 */
class FormDataConverter implements DataConverter
{
    /**
     * @var FormConverter
     */
    private $formConverter;

    /**
     * FormDataConverter constructor.
     *
     * @param FormConverter $formConverter
     */
    public function __construct(FormConverter $formConverter)
    {
        $this->formConverter = $formConverter;
    }

    /**
     * @param $data
     *
     * @return mixed
     */
    public function convert($data)
    {
        return $this->formConverter->convertForm($data);
    }

    /**
     * @param $data
     *
     * @return bool
     */
    public function handles($data): bool
    {
        return $data instanceof FormInterface;
    }
}
