<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\DependencyInjection;

use IssetBV\ErrorBundle\Service\Generator\ErrorGeneratorImpl;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVErrorExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');
        if ($config['form_data_handler']) {
            $loader->load('service_form_error.yml');
        }
        $definition = $container->register('isset_bv.error.generator', ErrorGeneratorImpl::class);
        $definition->addArgument(new Reference($config['error_generator_loader']));
        $definition->addArgument(new Reference($config['error_generator_view_generator']));
        $definition->addArgument(new Reference($config['error_generator_data_converter_container']));
    }
}
