<?php

declare(strict_types=1);

namespace IssetBV\ErrorBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_error');
        $rootNode->children()
            ->scalarNode('form_data_handler')->defaultFalse()->end()
            ->scalarNode('error_generator_loader')->cannotBeEmpty()->defaultValue('isset_bv.error.loader.no_cache')->end()
            ->scalarNode('error_generator_view_generator')->cannotBeEmpty()->defaultValue('isset_bv.error.generator.view.json_response')->end()
            ->scalarNode('error_generator_data_converter_container')->cannotBeEmpty()->defaultValue('isset_bv.error.generator.data_converter.container')->end()
            ->end();

        return $treeBuilder;
    }
}
