<?php

namespace IssetBv\EntityCreatedModifiedBundle\Listener;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;

class CreatorUpdate
{

    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if (in_array('setCreated', get_class_methods($entity))) {
            $entity->setCreated(new \DateTime());
        }
    }

    public function preUpdate(PreUpdateEventArgs $args)
    {
        $entity      = $args->getEntity();
        $recalculate = false;
        if (in_array('setUpdated', get_class_methods($entity))) {
            $entity->setUpdated(new \DateTime());
            $recalculate = true;
        }

        if ($recalculate) {
            //recalculate the changes for the updatedAt
            $em   = $args->getEntityManager();
            $uow  = $em->getUnitOfWork();
            $meta = $em->getClassMetadata(get_class($entity));
            $uow->recomputeSingleEntityChangeSet($meta, $entity);
        }
    }

}