<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Response;

class ResponseData implements ResponseDataInterface
{
    /**
     * @var int|null
     */
    private $statusCode;
    /**
     * @var string|null
     */
    private $body;

    public function __construct(int $statusCode = null, string $body = null)
    {
        $this->statusCode = $statusCode;
        $this->body = $body;
    }

    public function setStatusCode(int $statusCode = null)
    {
        $this->statusCode = $statusCode;
    }

    public function setBody(string $body = null)
    {
        $this->body = $body;
    }

    public function hasStatusCode(): bool
    {
        return null !== $this->statusCode;
        // TODO: Implement hasStatusCode() method.
    }

    public function hasBody(): bool
    {
        return null !== $this->body;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public static function fromArray(array $data): self
    {
        $instance = new self();
        if (array_key_exists('status_code', $data)) {
            $instance->setStatusCode($data['status_code']);
        }

        if (array_key_exists('body', $data)) {
            $instance->setBody($data['body']);
        }

        return $instance;
    }
}
