<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback;

use DateTime;
use IssetBV\CallbackBundle\Service\Callback\Response\ResponseDataInterface;

class CallbackData implements CallbackDataInterface
{
    /**
     * @var ResponseDataInterface
     */
    private $response;
    /**
     * @var string
     */
    private $method;
    /**
     * @var string
     */
    private $uri;
    /**
     * @var array
     */
    private $headers;
    /**
     * @var null
     */
    private $body;
    /**
     * @var string
     */
    private $version;
    /**
     * @var DateTime|null
     */
    private $sendDate;
    /**
     * @var string|null
     */
    private $groupIdentifier;

    public function __construct(
        ResponseDataInterface $response,
        string $method,
        string $uri,
        array $headers = [],
        $body = null,
        string $version = '1.1'
    ) {
        $this->response = $response;
        $this->method = $method;
        $this->uri = $uri;
        $this->headers = $headers;
        $this->body = $body;
        $this->version = $version;
    }

    public function getMethod(): string
    {
        return $this->method;
    }

    public function getUrl(): string
    {
        return $this->uri;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function getBody()
    {
        return $this->body;
    }

    public function getVersion(): string
    {
        return $this->version;
        // TODO: Implement getVersion() method.
    }

    /**
     * @param string $groupIdentifier
     */
    public function setGroupIdentifier(string $groupIdentifier)
    {
        $this->groupIdentifier = $groupIdentifier;
    }

    public function getGroupIdentifier()
    {
        return $this->groupIdentifier;
    }

    /**
     * @param DateTime $sendDate
     */
    public function setSendDate(DateTime $sendDate)
    {
        $this->sendDate = $sendDate;
    }

    public function getSendDate(): DateTime
    {
        if (null !== $this->sendDate) {
            return $this->sendDate;
        }

        return new DateTime();
    }

    public function getResponse(): ResponseDataInterface
    {
        return $this->response;
    }
}
