<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Repository;

use DateTime;
use Doctrine\ORM\EntityRepository;
use IssetBV\CallbackBundle\Entity\CallbackTry;
use IssetBV\CallbackBundle\Service\Callback\Processor\ProcessorInterface;
use IssetBV\CallbackBundle\Service\Callback\Processor\ProcessorProviderInterface;

class CallbackTryRepository extends EntityRepository implements ProcessorProviderInterface
{
    /**
     * @param string $type
     * @param int $amount
     * @param DateTime $dateUsed
     *
     * @return CallbackTry[]
     */
    public function fetchNextAmountAndType(string $type, int $amount, DateTime $dateUsed): array
    {
        $qb = $this->createQueryBuilder('try');

        $qb->select('try, callback');
        $qb->join('try.callback', 'callback');
        $qb->where('try.status = :status');
        $qb->andWhere('try.type = :type');
        $qb->andWhere('try.sendDate <= :sendDate');
        $qb->orderBy('try.created', 'ASC');
        $qb->setMaxResults($amount);
        $qb->setParameters([
            'status' => ProcessorInterface::STATUS_PENDING,
            'type' => $type,
            'sendDate' => $dateUsed,
        ]);

        return $qb->getQuery()->getResult();
    }
}
