<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\DependencyInjection;

use IssetBV\CallbackBundle\Service\Callback\CallbackInterface;
use IssetBV\CallbackBundle\Service\Callback\Processor\CallbackTryHandlerInterface;
use IssetBV\CallbackBundle\Service\Callback\Processor\ProcessorInterface;
use IssetBV\CallbackBundle\Service\Callback\Processor\ProcessorProviderInterface;
use IssetBV\CallbackBundle\Service\Callback\Response\ResponseHandlerInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class IssetBVCallbackExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $container->setAlias(CallbackInterface::class, $config['callback']);
        $container->setAlias(CallbackTryHandlerInterface::class, $config['callback_try_handler']);
        $container->setAlias(ProcessorInterface::class, $config['processor']);
        $container->setAlias(ProcessorProviderInterface::class, $config['processor_provider']);
        $container->setAlias(ResponseHandlerInterface::class, $config['response_handler']);
    }
}
