<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\DependencyInjection;

use IssetBV\CallbackBundle\Repository\CallbackTryRepository;
use IssetBV\CallbackBundle\Service\Callback\CallbackDoctrine;
use IssetBV\CallbackBundle\Service\Callback\Processor\HttpClientCallbackTryHandler;
use IssetBV\CallbackBundle\Service\Callback\Processor\Processor;
use IssetBV\CallbackBundle\Service\Callback\Response\ResponseHandler;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_callback');
        $rootNode->children()
            ->scalarNode('callback')->defaultValue(CallbackDoctrine::class)->end()
            ->scalarNode('callback_try_handler')->defaultValue(HttpClientCallbackTryHandler::class)->end()
            ->scalarNode('processor')->defaultValue(Processor::class)->end()
            ->scalarNode('processor_provider')->defaultValue(CallbackTryRepository::class)->end()
            ->scalarNode('response_handler')->defaultValue(ResponseHandler::class)->end()
            ->end();

        return $treeBuilder;
    }
}
