<?php

namespace IssetBv\CallbackBundle;

use IssetBv\CallbackBundle\Entity\Callback as CallbackEntity;
use IssetBv\CallbackBundle\Entity\CallbackParam;
use IssetBv\CallbackBundle\CallbackProcessor;
use \DateTime;

class Callback
{

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $doctrine;

    /**
     *
     * @var \IssetBv\CallbackBundle\CallbackProcessor
     */
    private $callbackProcessor;

    /**
     *
     * @var \IssetBv\CallbackBundle\Repository\CallbackRepository
     */
    private $callbackRepository;

    public function __construct($doctrine, CallbackProcessor $callbackProcessor)
    {
        $this->doctrine           = $doctrine;
        $this->callbackRepository = $this->doctrine->getRepository("IssetBvCallbackBundle:Callback");
        $this->callbackProcessor  = $callbackProcessor;
    }

    public function add($url, $params = array(), $groupIdentifier = null, DateTime $startDate = null, $responseStatusCode = null, $responseBody = null)
    {
        if ($startDate == null) {
            $startDate = new DateTime();
        }

        $callback = new CallbackEntity();
        $callback->setUrl($url);
        $callback->setGroupIdentifier($groupIdentifier);
        $callback->setNextTry($startDate);
        $callback->setResponseStatusCode($responseStatusCode);
        $callback->setResponseBody($responseBody);
        $this->doctrine->persist($callback);

        foreach ($params as $key => $value) {
            $callBackParam = new CallbackParam();
            $callBackParam->setKey($key);
            if (is_object($value) || is_array($value)) {
                $value = json_encode($value);
            }
            $callBackParam->setParam($value);
            $callBackParam->setCallback($callback);
            $this->doctrine->persist($callBackParam);
        }

        $this->doctrine->flush();
        return $callback->getId();
    }

    public function processFailed()
    {
        $callbacks = $this->callbackRepository->fetchProcessCallbacksFailed();
        return $this->handleCallbackIds($callbacks);
    }

    public function processNew()
    {
        $callbacks = $this->callbackRepository->fetchProcessCallbacksNew();
        return $this->handleCallbackIds($callbacks);
    }

    public function process()
    {
        $callbacks = $this->callbackRepository->fetchProcessCallbacks();
        return $this->handleCallbackIds($callbacks);
    }

    public function handleCallbackIds($callbacks)
    {
        if ($callbacks == null) {
            return -1;
        }

        foreach ($callbacks as $callback) {
            /* @var $callback \IssetBv\CallbackBundle\Entity\Callback */
            $check = $this->processCallback($callback);
            if ($check) {
                $groupIdentifier = $callback->getGroupIdentifier();
                if (empty($groupIdentifier)) {
                    continue;
                }
                $this->handleGroupFrom($callback);
            }
        }
    }

    public function handleGroupFrom(CallbackEntity $callbackFrom)
    {
        $callbacks = $this->callbackRepository->fetchProcessCallbacksForGroupIdentifier($callbackFrom->getId(), $callbackFrom->getGroupIdentifier());

        foreach ($callbacks as $callback) {
            $check = $this->processCallback($callback);
            if (!$check) {
                break;
            }
        }
    }

    public function processCallback(CallbackEntity $callback)
    {
        $return = $this->callbackProcessor->process($callback);
        $this->doctrine->flush();
        return $return;
    }

    public function retryCallback($retryDays)
    {
        if ($retryDays == -1) {
            $retryDays = 1461;
        }
        $dateTime  = new DateTime();
        $dateTime->modify('- ' . $retryDays . ' day');

        $qb      = $this->doctrine->createQueryBuilder()
                ->select('c')
                ->from('IssetBvCallbackBundle:Callback', 'c')
                ->where('c.success <= :success')
                ->andWhere('c.nextTry > :date')
                ->setParameter(':success', 'false')
                ->setParameter(':date', $dateTime);
        $results = $qb->getQuery()->execute();


        if ($results) {
            foreach ($results as $result) {
                $result->setTries(0);
                $result->setNextTry(new DateTime());
            }
            $this->doctrine->flush();
        }
    }

}
