<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Response;

use Psr\Http\Message\ResponseInterface as PsrResponseInterface;

class ResponseHandler implements ResponseHandlerInterface
{
    public function validateResponse(ResponseDataInterface $responseData, PsrResponseInterface $response): bool
    {
        if ($responseData->hasStatusCode() && $responseData->getStatusCode() !== $response->getStatusCode()) {
            return false;
        }

        if ($responseData->hasBody() && $responseData->getBody() !== trim((string) $response->getBody())) {
            return false;
        }

        return true;
    }
}
