<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Processor;

use DateTime;

class Processor implements ProcessorInterface
{
    /**
     * @var ProcessorProviderInterface
     */
    private $processorProvider;

    /**
     * @var CallbackTryHandlerInterface
     */
    private $callbackTryHandler;

    public function __construct(ProcessorProviderInterface $processorProvider, CallbackTryHandlerInterface $callbackTryHandler)
    {
        $this->processorProvider = $processorProvider;
        $this->callbackTryHandler = $callbackTryHandler;
    }

    public function process(string $type, int $amount, DateTime $dateUsed): int
    {
        $callbackTries = $this->processorProvider->fetchNextAmountAndType($type, $amount, $dateUsed);

        foreach ($callbackTries as $callbackTry) {
            $this->callbackTryHandler->handle($callbackTry);
        }

        return \count($callbackTries);
    }
}
