<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Response;

use Psr\Http\Message\ResponseInterface as PsrResponseInterface;

class StatusCodeResponse implements ResponseInterface
{
    /**
     * @var int
     */
    private $statusCode;

    public function __construct(int $statusCode)
    {
        $this->statusCode = $statusCode;
    }

    public function serialize()
    {
        return serialize($this->statusCode);
    }

    public function unserialize($serialized)
    {
        $this->statusCode = unserialize($serialized);
    }

    public function validateResponse(PsrResponseInterface $response): bool
    {
        return $response->getStatusCode() === $this->statusCode;
    }
}
