<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Response;

use Psr\Http\Message\ResponseInterface as PsrResponseInterface;

class BodyMatchStatusCodeResponse implements ResponseInterface
{
    /**
     * @var StatusCodeResponse
     */
    private $statusCode;
    /**
     * @var BodyMatchResponse
     */
    private $body;

    public function __construct(string $body, int $statusCode)
    {
        $this->body = new BodyMatchResponse($body);
        $this->statusCode = new StatusCodeResponse($statusCode);
    }

    public function serialize()
    {
        return serialize([
            $this->body,
            $this->statusCode,
        ]);
    }

    public function unserialize($serialized)
    {
        list($this->body, $this->statusCode) = unserialize($serialized, [
            'allowed_classes' => [
                BodyMatchResponse::class,
                StatusCodeResponse::class,
            ],
        ]);
    }

    public function validateResponse(PsrResponseInterface $response): bool
    {
        return $this->statusCode->validateResponse($response) && $this->body->validateResponse($response);
    }
}
