<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback\Response;

use Psr\Http\Message\ResponseInterface as PsrResponseInterface;

class BodyMatchResponse implements ResponseInterface
{
    /**
     * @var string
     */
    private $body;

    public function __construct(string $body)
    {
        $this->body = $body;
    }

    public function serialize()
    {
        return serialize($this->body);
    }

    public function unserialize($serialized)
    {
        $this->body = unserialize($serialized);
    }

    public function validateResponse(PsrResponseInterface $response): bool
    {
        return trim((string) $response->getBody()) === $this->body;
    }
}
