<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Service\Callback;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\CallbackBundle\Entity\Callback;
use IssetBV\CallbackBundle\Entity\CallbackTry;
use IssetBV\CallbackBundle\Service\Callback\Processor\ProcessorInterface;

class CallbackDoctrine implements CallbackInterface
{
    /**
     * @var ObjectManager
     */
    private $objectManager;

    public function __construct(ObjectManager $objectManager)
    {
        $this->objectManager = $objectManager;
    }

    public function add(CallbackDataInterface $callbackData)
    {
        $callback = new Callback();
        $callback->setResponse($callbackData->getResponse());
        $callback->setBody($callbackData->getBody());
        $callback->setGroupIdentifier($callbackData->getGroupIdentifier());
        $callback->setHeaders($callbackData->getHeaders());
        $callback->setMethod($callbackData->getMethod());
        $callback->setUrl($callbackData->getUrl());
        $callback->setVersion($callbackData->getVersion());

        $callbackTry = new CallbackTry(
            ProcessorInterface::TYPE_NEW,
            ProcessorInterface::STATUS_PENDING,
            $callback,
            $callbackData->getSendDate()
        );

        $this->objectManager->persist($callback);
        $this->objectManager->persist($callbackTry);
        $this->objectManager->flush();
    }
}
