<?php

declare(strict_types=1);

namespace IssetBV\CallbackBundle\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\CallbackBundle\Service\Callback\Response\ResponseInterface;

/**
 * @ORM\Table(name="issetbv_callbacks")
 * @ORM\Entity()
 */
class Callback
{
    /**
     * @var int|null
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;
    /**
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $maxTries = 5;
    /**
     * @var CallbackTry[]|ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="CallbackTry", mappedBy="callback")
     */
    private $tries;
    /**
     * @var string
     *
     * @ORM\Column(type="text", nullable=false)
     */
    private $response;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $method;
    /**
     * @var string
     *
     * @ORM\Column(type="text", nullable=false)
     */
    private $url;
    /**
     * @var array
     *
     * @ORM\Column(type="json_array", nullable=false)
     */
    private $headers;
    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $body;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $version;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $groupIdentifier;
    /**
     * @var DateTime|null
     *
     * @ORM\Column(name="date_sent", type="datetime", nullable=true)
     */
    private $sentDate;
    /**
     * @var DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $created;
    /**
     * @var DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $updated;

    public function __construct()
    {
        $this->tries = new ArrayCollection();
        $this->created = new DateTime();
        $this->updated = new DateTime();
    }

    /**
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getMaxTries(): int
    {
        return $this->maxTries;
    }

    /**
     * @param int $maxTries
     */
    public function setMaxTries(int $maxTries)
    {
        $this->maxTries = $maxTries;
    }

    /**
     * @return ResponseInterface
     */
    public function getResponse(): ResponseInterface
    {
        return unserialize($this->response);
    }

    public function setResponse(ResponseInterface $response)
    {
        $this->response = serialize($response);
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return $this->method;
    }

    /**
     * @param string $method
     */
    public function setMethod(string $method)
    {
        $this->method = $method;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl(string $url)
    {
        $this->url = $url;
    }

    /**
     * @return array
     */
    public function getHeaders(): array
    {
        return $this->headers;
    }

    /**
     * @param array $headers
     */
    public function setHeaders(array $headers)
    {
        $this->headers = $headers;
    }

    public function getBody()
    {
        if (null === $this->body) {
            return null;
        }

        return unserialize($this->body);
    }

    public function setBody($body = null)
    {
        if (null === $body) {
            $this->body = $body;
        } else {
            $this->body = serialize($body);
        }
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @param string $version
     */
    public function setVersion(string $version)
    {
        $this->version = $version;
    }

    /**
     * @return string
     */
    public function getGroupIdentifier(): string
    {
        return $this->groupIdentifier;
    }

    /**
     * @param string $groupIdentifier
     */
    public function setGroupIdentifier(string $groupIdentifier = null)
    {
        $this->groupIdentifier = $groupIdentifier;
    }

    /**
     * @return DateTime|null
     */
    public function getSentDate()
    {
        return $this->sentDate;
    }

    /**
     * @param DateTime $sentDate
     */
    public function setSentDate(DateTime $sentDate)
    {
        $this->sentDate = $sentDate;
        $this->updated = new DateTime();
    }

    /**
     * @return DateTime
     */
    public function getCreated(): DateTime
    {
        return $this->created;
    }

    /**
     * @return DateTime
     */
    public function getUpdated(): DateTime
    {
        return $this->updated;
    }

    public function reTry(): bool
    {
        $maxTries = $this->getMaxTries();
        if (0 === $maxTries) {
            return false;
        }

        return $maxTries > $this->getTriesCount();
    }

    public function getTriesCount(): int
    {
        return $this->tries->count();
    }

    public function addTry(CallbackTry $callbackTry)
    {
        $this->tries->add($callbackTry);
    }
}
