<?php
namespace IssetBv\CallbackBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Callback
 *
 * @ORM\Table(name="issetbv_callbacks",indexes={@ORM\Index(name="callback_success_next_try", columns={"success", "next_try" }), @ORM\Index(name="callback_group_identifier", columns={"group_identifier" })})
 * @ORM\Entity(repositoryClass="IssetBv\CallbackBundle\Repository\CallbackRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Callback
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="string", nullable=false)
     */
    private $url;

    /**
     * @var string
     *
     * @ORM\Column(name="group_identifier", type="string", nullable=true)
     */
    private $groupIdentifier;

    /**
     * @var string
     *
     * @ORM\Column(name="success", type="boolean", nullable=false)
     */
    private $success = false;

    /**
     * @var string
     *
     * @ORM\Column(name="tries", type="integer", nullable=false)
     */
    private $tries = 0;

    /**
     * @var string
     *
     * @ORM\Column(name="tries_max", type="integer", nullable=false)
     */
    private $triesMax = 5;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="next_try", type="datetime", nullable=true)
     */
    private $nextTry;

    /**
     * @var string
     *
     * @ORM\Column(name="response_status_code", type="string", nullable=true)
     */
    private $responseStatusCode = null;

    /**
     * @var string
     *
     * @ORM\Column(name="response_body", type="text", nullable=true)
     */
    private $responseBody = null;

    /**
     * @ORM\OneToMany(targetEntity="CallbackTry", mappedBy="callback")
     * @ORM\JoinColumn(name="callback_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $responses;

    /**
     * @ORM\OneToMany(targetEntity="CallbackParam", mappedBy="callback")
     * @ORM\JoinColumn(name="callback_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $params;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="created", type="datetime", nullable=true)
     */
    private $created;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->responses = new ArrayCollection();
        $this->params = new ArrayCollection();
        $this->created = new DateTime();
        $this->updated = new DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set url
     *
     * @param string $url
     * @return Callback
     */
    public function setUrl($url)
    {
        $this->url = $url;
        
        return $this;
    }

    /**
     * Get url
     *
     * @return string 
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set groupIdentifier
     *
     * @param string $groupIdentifier
     * @return Callback
     */
    public function setGroupIdentifier($groupIdentifier)
    {
        $this->groupIdentifier = $groupIdentifier;
        
        return $this;
    }

    /**
     * Get groupIdentifier
     *
     * @return string 
     */
    public function getGroupIdentifier()
    {
        return $this->groupIdentifier;
    }

    /**
     * Set success
     *
     * @param boolean $success
     * @return Callback
     */
    public function setSuccess($success)
    {
        $this->success = $success;
        
        return $this;
    }

    /**
     * Get success
     *
     * @return boolean 
     */
    public function getSuccess()
    {
        return $this->success;
    }

    /**
     * Set tries
     *
     * @param integer $tries
     * @return Callback
     */
    public function setTries($tries)
    {
        $this->tries = $tries;
        
        return $this;
    }

    /**
     * Get tries
     *
     * @return integer 
     */
    public function getTries()
    {
        return $this->tries;
    }

    /**
     * Set triesMax
     *
     * @param integer $triesMax
     * @return Callback
     */
    public function setTriesMax($triesMax)
    {
        $this->triesMax = $triesMax;
        
        return $this;
    }

    /**
     * Get triesMax
     *
     * @return integer 
     */
    public function getTriesMax()
    {
        return $this->triesMax;
    }

    /**
     * Set nextTry
     *
     * @param DateTime $nextTry
     * @return Callback
     */
    public function setNextTry($nextTry)
    {
        $this->nextTry = $nextTry;
        
        return $this;
    }

    /**
     * Get nextTry
     *
     * @return DateTime 
     */
    public function getNextTry()
    {
        return $this->nextTry;
    }

    /**
     * Set reponseStatusCode
     *
     * @param string $reponseStatusCode
     * @return Callback
     */
    public function setResponseStatusCode($responseStatusCode)
    {
        $this->responseStatusCode = $responseStatusCode;
        
        return $this;
    }

    /**
     * Get reponseStatusCode
     *
     * @return string 
     */
    public function getResponseStatusCode()
    {
        return $this->responseStatusCode;
    }

    /**
     * Set reponseBody
     *
     * @param string $reponseBody
     * @return Callback
     */
    public function setResponseBody($responseBody)
    {
        $this->responseBody = $responseBody;
        
        return $this;
    }

    /**
     * Get reponseBody
     *
     * @return string 
     */
    public function getResponseBody()
    {
        return $this->responseBody;
    }

    /**
     * Set created
     *
     * @param DateTime $created
     * @return Callback
     */
    public function setCreated($created)
    {
        $this->created = $created;
        
        return $this;
    }

    /**
     * Get created
     *
     * @return DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param DateTime $updated
     * @return Callback
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        
        return $this;
    }

    /**
     * Get updated
     *
     * @return DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Add responses
     *
     * @param CallbackTry $responses
     * @return Callback
     */
    public function addResponse(CallbackTry $responses)
    {
        $this->responses[] = $responses;
        
        return $this;
    }

    /**
     * Remove responses
     *
     * @param CallbackTry $responses
     */
    public function removeResponse(CallbackTry $responses)
    {
        $this->responses->removeElement($responses);
    }

    /**
     * Get responses
     *
     * @return Collection 
     */
    public function getResponses()
    {
        return $this->responses;
    }

    /**
     * Add params
     *
     * @param CallbackParam $params
     * @return Callback
     */
    public function addParam(CallbackParam $params)
    {
        $this->params[] = $params;
        
        return $this;
    }

    /**
     * Remove params
     *
     * @param CallbackParam $params
     */
    public function removeParam(CallbackParam $params)
    {
        $this->params->removeElement($params);
    }

    /**
     * Get params
     *
     * @return Collection 
     */
    public function getParams()
    {
        return $this->params;
    }

    /** 
     * @ORM\PreUpdate() 
     */
    public function refreshDateUpdated()
    {
        $this->updated = new DateTime();
    }
}