<?php
namespace IssetBv\CallbackBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Call
 *
 * @ORM\Table(name="issetbv_callback_tries")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks 
 */
class CallbackTry
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Callback", inversedBy="responses")
     * @ORM\JoinColumn(name="callback_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $callback;

    /**
     * @var string
     *
     * @ORM\Column(name="reponse_code", type="string", nullable=false)
     */
    private $reponseCode;

    /**
     * @var string
     *
     * @ORM\Column(name="reponse_body", type="text", nullable=false)
     */
    private $responseBody;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="created", type="datetime", nullable=true)
     */
    private $created;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     */
    private $updated;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->created = new DateTime();
        $this->updated = new DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reponseCode
     *
     * @param string $reponseCode
     * @return CallbackTry
     */
    public function setReponseCode($reponseCode)
    {
        $this->reponseCode = $reponseCode;
        
        return $this;
    }

    /**
     * Get reponseCode
     *
     * @return string 
     */
    public function getReponseCode()
    {
        return $this->reponseCode;
    }

    /**
     * Set responseBody
     *
     * @param string $responseBody
     * @return CallbackTry
     */
    public function setResponseBody($responseBody)
    {
        $this->responseBody = $responseBody;
        
        return $this;
    }

    /**
     * Get responseBody
     *
     * @return string 
     */
    public function getResponseBody()
    {
        return $this->responseBody;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return CallbackTry
     */
    public function setCreated($created)
    {
        $this->created = $created;
        
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return CallbackTry
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        
        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set callback
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $callback
     * @return CallbackTry
     */
    public function setCallback(\IssetBv\CallbackBundle\Entity\Callback $callback = null)
    {
        $this->callback = $callback;
        
        return $this;
    }

    /**
     * Get callback
     *
     * @return \IssetBv\CallbackBundle\Entity\Callback 
     */
    public function getCallback()
    {
        return $this->callback;
    }

    /**
     * @ORM\PreUpdate()
     */
    public function refreshDateUpdated()
    {
        $this->updated = new DateTime();
    }
}