<?php

namespace IssetBv\CallbackBundle\Repository;

use Doctrine\ORM\EntityRepository;
use \DateTime;

class CallbackRepository extends EntityRepository
{

    public function getLast($number = 20)
    {
        $result = $this
                ->createQueryBuilder('c')
                ->select('c')
                ->orderBy("c.id", "DESC")
                ->setMaxResults($number)
                ->getQuery()
                ->getResult();
        return $result;
    }

    public function getChilds($id, $groupIdentifier)
    {
        $result = $this
                ->createQueryBuilder('c')
                ->select('c')
                ->where('c.groupIdentifier = :groupIdentifier')
                ->andWhere('c.id > :id')
                ->setParameter(':id', $id)
                ->setParameter(':groupIdentifier', $groupIdentifier)
                ->getQuery()
                ->getResult();
        return $result;
    }

    private function mapIds($ids)
    {
        return array_map(function($array) {
                            return $array['id'];
                        }, $ids);
    }

    public function fetchProcessCallbacksFailed($maxResults = 50, $minDays = 3)
    {
        $min = new DateTime();
        $min->modify("-" . $minDays . " days");

        $ids = $this->createQueryBuilder('c')->select("MIN(c.id) as id")
                ->where('c.success = false')
                ->andWhere('c.nextTry IS NOT NULL')
                ->andWhere('c.nextTry <= :nexttry')
                ->andWhere('c.nextTry >= :min')
                ->andWhere('c.tries >= 1')
                ->setParameter(':nexttry', new DateTime())
                ->setParameter(':min', $min)
                ->groupBy('c.groupIdentifier')
                ->getQuery()
                ->setMaxResults($maxResults)
                ->getArrayResult()
        ;

        if (empty($ids)) {
            return null;
        }

        return $this->fetchCallbackForIds($this->mapIds($ids));
    }

    public function fetchProcessCallbacksNew($maxResults = 50, $minDays = 3)
    {
        $min = new DateTime();
        $min->modify("-" . $minDays . " days");

        $ids = $this->createQueryBuilder('c')->select("MIN(c.id) as id")
                ->where('c.success = false')
                ->andWhere('c.nextTry IS NOT NULL')
                ->andWhere('c.nextTry <= :nexttry')
                ->andWhere('c.nextTry >= :min')
                ->andWhere('c.tries = 0')
                ->setParameter(':nexttry', new DateTime())
                ->setParameter(':min', $min)
                ->groupBy('c.groupIdentifier')
                ->getQuery()
                ->setMaxResults($maxResults)
                ->getArrayResult()
        ;


        if (empty($ids)) {
            return null;
        }

        return $this->fetchCallbackForIds($this->mapIds($ids));
    }

    public function fetchProcessCallbacks($maxResults = 50, $minDays = 3)
    {
        $min = new DateTime();
        $min->modify("-" . $minDays . " days");

        $ids = $this->createQueryBuilder('c')->select("MIN(c.id) as id")
                ->where('c.success = false')
                ->andWhere('c.nextTry IS NOT NULL')
                ->andWhere('c.nextTry <= :nexttry')
                ->andWhere('c.nextTry >= :min')
                ->setParameter(':nexttry', new DateTime())
                ->setParameter(':min', $min)
                ->groupBy('c.groupIdentifier')
                ->getQuery()
                ->setMaxResults($maxResults)
                ->getArrayResult()
        ;

        if (empty($ids)) {
            return null;
        }

        return $this->fetchCallbackForIds($this->mapIds($ids));
    }

    public function fetchProcessCallbacksForGroupIdentifier($id, $groupIdentifier)
    {
        return $this->createQueryBuilder('c')
                        ->where('c.success = false')
                        ->andWhere('c.nextTry IS NOT NULL')
                        ->andWhere('c.id > :id')
                        ->andWhere("c.groupIdentifier = :identifier")
                        ->andWhere('c.nextTry <= :nexttry')
                        ->setParameter(':nexttry', new DateTime())
                        ->setParameter(":id", $id)
                        ->setParameter(":identifier", $groupIdentifier)
                        ->getQuery()
                        ->execute()
        ;
    }

    public function fetchCallbackForIds(array $ids)
    {
        return $this->createQueryBuilder('c')->select('c, p')
                        ->leftJoin('c.params', 'p')
                        ->where('c IN(:callbacks)')
                        ->setParameter(':callbacks', $ids)
                        ->getQuery()
                        ->execute();
        ;
    }

}
