<?php

namespace IssetBv\CallbackBundle\Caller;

use IssetBv\CallbackBundle\Entity\Callback;
use Guzzle\Http\Client;
use Guzzle\Http\Exception\CurlException;
use \Exception;

class GuzzleCall implements Call
{

    private $client;

    public function __construct()
    {
        $this->client = new Client();
    }

    /**
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $call
     * @return \IssetBv\CallbackBundle\Caller\Response
     */
    public function call(Callback $call)
    {
        $post = $this->client->post($call->getUrl(), null, null, array(
            'timeout' => 2,
            'connect_timeout' => 1
                )
        );

        $fields = array();
        foreach ($call->getParams() as $param) {
            /* @var $param \IssetBv\CallbackBundle\Entity\CallbackParam */
            if ($param->getKey() == 'lastMessages') {
                $fields[$param->getKey()] = '[]';
            } else {
                $fields[$param->getKey()] = $param->getParam();
            }
        }

        if (!empty($fields)) {
            $post->addPostFields($fields);
        }

        $message = '';
        try {
            $response = $post->send();
        } catch (CurlException $e) {
            $message  = $e->getMessage();
            $response = false;
        } catch (Exception $e) {
            $response   = $e->getResponse();
        }
        $send       = false;
        $statusCode = -1;

        if ($response) {
            $message    = $response->getBody(true);
            $statusCode = $response->getStatusCode();
            $send       = true;
            /* @var $response \Guzzle\Http\Message\Response */
        }

        return new Response($send, $statusCode, $message);
    }

}