<?php

namespace IssetBv\CallbackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Call
 *
 * @ORM\Table(name="issetbv_callback_params")
 * @ORM\Entity
 */
class CallbackParam
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Callback", inversedBy="params")
     * @ORM\JoinColumn(name="callback_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $callback;

    /**
     * @var string
     *
     * @ORM\Column(name="value_key", type="string", nullable=false)
     */
    private $key;

    /**
     * @var string
     *
     * @ORM\Column(name="param", type="text", nullable=false)
     */
    private $param;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    private $updated;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set param
     *
     * @param string $param
     * @return CallbackParam
     */
    public function setParam($param)
    {
        $this->param = $param;

        return $this;
    }

    /**
     * Get param
     *
     * @return string 
     */
    public function getParam()
    {
        return $this->param;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return CallbackParam
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return CallbackParam
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set callback
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $callback
     * @return CallbackParam
     */
    public function setCallback(\IssetBv\CallbackBundle\Entity\Callback $callback = null)
    {
        $this->callback = $callback;

        return $this;
    }

    /**
     * Get callback
     *
     * @return \IssetBv\CallbackBundle\Entity\Callback 
     */
    public function getCallback()
    {
        return $this->callback;
    }


    /**
     * Set key
     *
     * @param string $key
     * @return CallbackParam
     */
    public function setKey($key)
    {
        $this->key = $key;
    
        return $this;
    }

    /**
     * Get key
     *
     * @return string 
     */
    public function getKey()
    {
        return $this->key;
    }
}