<?php

namespace IssetBv\CallbackBundle\Caller;

use IssetBv\CallbackBundle\Entity\Callback;
use Guzzle\Http\Client;

class GuzzleCall implements Call
{

    private $client;

    public function __construct()
    {
        $this->client = new Client();
    }

    /**
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $call
     * @return \IssetBv\CallbackBundle\Caller\Response
     */
    public function call(Callback $call)
    {
        $post = $this->client->post($call->getUrl(), null, null, array(
            'timeout' => 10,
            'connect_timeout' => 3
                )
        );

        $fields = array();
        foreach ($call->getParams() as $param) {
            /* @var $param \IssetBv\CallbackBundle\Entity\CallbackParam */
            $fields[$param->getKey()] = $param->getParam();
        }

        if (!empty($fields)) {
            $post->addPostFields($fields);
        }

        $message = '';
        try {
            $response = $post->send();
        } catch (\Guzzle\Http\Exception\CurlException $e) {
            $message  = $e->getMessage();
            $response = false;
        } catch (\Exception $e) {
            $response   = $e->getResponse();
        }
        $send       = false;
        $statusCode = -1;

        if ($response) {
            $message    = $response->getBody(true);
            $statusCode = $response->getStatusCode();
            $send       = true;
            /* @var $response \Guzzle\Http\Message\Response */
        }

        return new Response($send, $statusCode, $message);
    }

}