<?php

namespace IssetBv\CallbackBundle\Repository;

use Doctrine\ORM\EntityRepository;

class CallbackRepository extends EntityRepository
{

    public function getLast($number = 20)
    {
        $result = $this
                ->createQueryBuilder('c')
                ->select('c')
                ->orderBy("c.id", "DESC")
                ->setMaxResults($number)
                ->getQuery()
                ->getResult();
        return $result;
    }

    public function getChilds($id, $groupIdentifier)
    {
        $result = $this
                ->createQueryBuilder('c')
                ->select('c')
                ->where('c.groupIdentifier = :groupIdentifier')
                ->andWhere('c.id > :id')
                ->setParameter(':id', $id)
                ->setParameter(':groupIdentifier', $groupIdentifier)
                ->getQuery()
                ->getResult();
        return $result;
    }

}
