<?php

namespace IssetBv\CallbackBundle\Caller;

use IssetBv\CallbackBundle\Entity\Callback;

class SocketCall implements Call
{

    private $connected = false;
    private $socket    = false;
    private $ip;
    private $port;

    public function __construct($connect)
    {
        $location   = explode(':', $connect);
        $this->ip   = array_shift($location);
        $this->port = array_shift($location);
    }

    /**
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $call
     * @return \IssetBv\CallbackBundle\Caller\Response
     */
    public function call(Callback $call)
    {
        if (!$this->connected) {
            $this->connect();
        }

        $url    = $call->getUrl();
        $params = array();

        foreach ($call->getParams() as $param) {
            /* @var $param \IssetBv\CallbackBundle\Entity\CallbackParam */
            $params[] = array(
                'name' => $param->getKey(),
                'value' => $param->getParam()
            );
        }

        $message = array(
            'legit' => true,
            'url' => $url,
            'params' => $params
        );

        fwrite($this->socket, json_encode($message) . "\n");
        $msg  = fgets($this->socket);
        $data = json_decode($msg);
        return new Response($data->send, $data->statusCode, $data->response);
    }

    private function connect()
    {
        $this->connected = true;
        $this->socket    = fsockopen($this->ip, $this->port);
    }

    public function __destruct()
    {
        $this->connected = false;
        if ($this->socket) {
            fclose($this->socket);
        }
    }

}