<?php

namespace IssetBv\CallbackBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use IssetBv\CallbackBundle\Entity\Callback;

class ManagerController extends Controller
{

    public function indexAction()
    {
        $rows = $this->getDoctrine()->getRepository("IssetBvCallbackBundle:Callback")->getLast();
        return $this->render("IssetBvCallbackBundle:Manager:overview.html.twig", array('rows' => $rows));
    }

    public function postAction()
    {
        $rows = $this->getDoctrine()->getRepository("IssetBvCallbackBundle:Callback")->findBy(array($_POST['type'] => $_POST['text']));
        return $this->render("IssetBvCallbackBundle:Manager:overview.html.twig", array('rows' => $rows));
    }

    public function redoFromHereAction(Callback $callback)
    {
        $now = new \DateTime();
        $callback->setNextTry($now);
        $callback->setTries(0);
        $callback->setSuccess(false);

        $groupIdentifier = $callback->getGroupIdentifier();
        if (!empty($groupIdentifier)) {
            $rows = $this->getDoctrine()->getRepository("IssetBvCallbackBundle:Callback")->getChilds($callback->getId(), $callback->getGroupIdentifier());
            foreach ($rows as $row) {
                /* @var $row \IssetBv\CallbackBundle\Entity\Callback */
                $row->setNextTry($now);
                $row->setTries(0);
                $row->setSuccess(false);
            }
        }
        $this->getDoctrine()->getManager()->flush();
        return $this->redirect($this->generateUrl("callbackbundle.manager"));
    }

}
