<?php

namespace IssetBv\CallbackBundle;

use Guzzle\Http\Client;

class Callback
{

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $doctrine;

    public function __construct($doctrine)
    {
        $this->doctrine = $doctrine;
    }

    public function add($url, $params = array(), \DateTime $startDate = null)
    {

        if (empty($startDate)) {
            $startDate = new \DateTime();
        }

        $callback = new Entity\Callback();
        $callback->setUrl($url);
        $callback->setNextTry($startDate);
        $this->doctrine->persist($callback);

        foreach ($params as $key => $value) {
            $callBackParam = new Entity\CallbackParam();
            $callBackParam->setKey($key);
            $callBackParam->setParam($value);
            $callBackParam->setCallback($callback);
            $this->doctrine->persist($callBackParam);
        }

        $this->doctrine->flush();
    }

    public function process()
    {
        $qb      = $this->doctrine->createQueryBuilder();
        $qb->select('c')->from('IssetBvCallbackBundle:Callback', 'c')->where('c.nextTry <= :nexttry');
        $qb->setParameter(':nexttry', new \DateTime());
        $results = $qb->getQuery()->execute();
        foreach ($results as $callback) {
            $this->processCallback($callback);
        }
    }

    public function processCallback(\IssetBv\CallbackBundle\Entity\Callback $callback)
    {

        $callbackTry = new Entity\CallbackTry();
        $callbackTry->setCallback($callback);


        $client = new Client($callback->getUrl());
        $post   = $client->post();
        $fields = array();

        foreach ($callback->getParams() as $param) {
            /* @var $param \IssetBv\CallbackBundle\Entity\CallbackParam */
            $fields[$param->getKey()] = $param->getParam();
        }

        if (!empty($fields)) {
            $post->addPostFields($fields);
        }

        try {
            $response = $post->send();
        } catch (\Guzzle\Http\Exception\CurlException $e) {
            $response = false;
        } catch (\Exception $e) {
            $response = $e->getResponse();
        }
        if ($response) {
            /* @var $response \Guzzle\Http\Message\Response */
            $callbackTry->setReponseCode($response->getStatusCode());
            $callbackTry->setResponseBody($response->getBody());
            $this->doctrine->persist($callbackTry);
        }


        $tries = $callback->getTries();
        $callback->setTries(++$tries);
        $callback->setNextTry(null);
        if ($response && ($response->getStatusCode() == '202' OR ($response->getStatusCode() == '200' && trim($response->getBody(true)) == '[success]'))) {
            $callback->setSuccess(true);
        } else {
            $now = new \DateTime();
            if ($callback->getTries() <= $callback->getTriesMax()) {
                $now->modify('+ ' . 5 * $callback->getTries() . ' minutes');
                $callback->setNextTry($now);
            }
        }

        $this->doctrine->flush();
    }

    public function retryCallback($retryDays)
    {
        if ($retryDays == -1) {
            $retryDays = 1461;
        }
        $dateTime  = new \DateTime();
        $dateTime->modify('- ' . $retryDays . ' day');

        $qb      = $this->doctrine->createQueryBuilder()
                ->select('c')
                ->from('IssetBvCallbackBundle:Callback', 'c')
                ->where('c.success <= :success')
                ->andWhere('c.nextTry > :date')
                ->setParameter(':success', 'false')
                ->setParameter(':date', $dateTime);
        $results = $qb->getQuery()->execute();


        if ($results) {
            foreach ($results as $result) {
                $result->setTries(0);
                $result->setNextTry(new \DateTime());
            }
            $this->doctrine->flush();
        }
    }

}
