<?php

namespace IssetBv\CallbackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Call
 *
 * @ORM\Table(name="issetbv_callback_tries")
 * @ORM\Entity
 */
class CallbackTry
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Callback")
     * @ORM\JoinColumn(name="callback_id", referencedColumnName="id")
     */
    private $callback;

    /**
     * @var string
     *
     * @ORM\Column(name="reponse_code", type="string", nullable=false)
     */
    protected $reponseCode;

    /**
     * @var string
     *
     * @ORM\Column(name="reponse_body", type="text", nullable=false)
     */
    protected $responseBody;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    private $created;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    private $updated;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reponseCode
     *
     * @param string $reponseCode
     * @return CallbackTry
     */
    public function setReponseCode($reponseCode)
    {
        $this->reponseCode = $reponseCode;
    
        return $this;
    }

    /**
     * Get reponseCode
     *
     * @return string 
     */
    public function getReponseCode()
    {
        return $this->reponseCode;
    }

    /**
     * Set responseBody
     *
     * @param string $responseBody
     * @return CallbackTry
     */
    public function setResponseBody($responseBody)
    {
        $this->responseBody = $responseBody;
    
        return $this;
    }

    /**
     * Get responseBody
     *
     * @return string 
     */
    public function getResponseBody()
    {
        return $this->responseBody;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return CallbackTry
     */
    public function setCreated($created)
    {
        $this->created = $created;
    
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated
     * @return CallbackTry
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    
        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set callback
     *
     * @param \IssetBv\CallbackBundle\Entity\Callback $callback
     * @return CallbackTry
     */
    public function setCallback(\IssetBv\CallbackBundle\Entity\Callback $callback = null)
    {
        $this->callback = $callback;
    
        return $this;
    }

    /**
     * Get callback
     *
     * @return \IssetBv\CallbackBundle\Entity\Callback 
     */
    public function getCallback()
    {
        return $this->callback;
    }
}