<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\DependencyInjection;

use IssetBV\CacheBundle\Service\Predis\PredisCache;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_cache');
        $rootNode
            ->children()
            ->scalarNode('default')->defaultNull()->end()
            ->scalarNode('container')->defaultTrue()->end()
            ->arrayNode('redis')
            ->prototype('array')
            ->children()
            ->scalarNode('host')->isRequired()->end()
            ->scalarNode('port')->defaultValue('6379')->end()
            ->scalarNode('persistent')->defaultFalse()->end()
            ->scalarNode('driver')->defaultValue(PredisCache::class)->end()
            ->scalarNode('lazy')->defaultTrue()->end()
            ->end()
            ->end()
            ->end()
            ->end();

        return $treeBuilder;
    }
}
