<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\CacheContainer;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CacheGetCommand extends Command
{
    /**
     * @var CacheContainer
     */
    private $cacheClientContainer;

    public function __construct(string $name = null, CacheContainer $cacheClientContainer)
    {
        parent::__construct($name);
        $this->cacheClientContainer = $cacheClientContainer;
    }

    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('issetbv:cache:get');
        $this->addArgument(
            'cache',
            InputArgument::REQUIRED,
            'Cache to use'
        );
        $this->addArgument(
            'key',
            InputArgument::REQUIRED,
            'cache key to get'
        );
        $this->setDescription('get a cache item');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $client = $this->cacheClientContainer->getByName($input->getArgument('cache'));
        $data = $client->get($input->getArgument('key'));
        if (null === $data) {
            $output->writeln('<error>NULL</error>');
        } else {
            $output->writeln($data);
        }
    }
}
