<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\CacheContainer;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CacheFlushAllCommand extends Command
{
    /**
     * @var CacheContainer
     */
    private $cacheClientContainer;

    public function __construct(string $name = null, CacheContainer $cacheClientContainer)
    {
        parent::__construct($name);
        $this->cacheClientContainer = $cacheClientContainer;
    }

    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('issetbv:cache:flush-all');
        $this->addArgument(
            'cache',
            InputArgument::REQUIRED,
            'Cache to use'
        );
        $this->setDescription('delete all items from cache');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->cacheClientContainer->getByName($input->getArgument('cache'))->flush();
    }
}
