<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service;

class CacheContainer
{
    /**
     * @var CacheInterface[]
     */
    private $cache = [];

    public function add(string $name, CacheInterface $cacheClient)
    {
        $this->cache[$name] = $cacheClient;
    }

    /**
     * @param string $name
     *
     * @throws CacheContainerException
     *
     * @return CacheInterface
     */
    public function getByName(string $name): CacheInterface
    {
        if (!array_key_exists($name, $this->cache)) {
            throw new CacheContainerException("Client with name [$name] not found");
        }

        return $this->cache[$name];
    }
}
