<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\DependencyInjection;

use IssetBV\CacheBundle\Command\CacheDeleteCommand;
use IssetBV\CacheBundle\Command\CacheFlushAllCommand;
use IssetBV\CacheBundle\Command\CacheGetCommand;
use IssetBV\CacheBundle\Command\CacheSetCommand;
use IssetBV\CacheBundle\Service\CacheContainer;
use IssetBV\CacheBundle\Service\CacheInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class IssetBVCacheExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $clientContainer = null;

        if ($config['container']) {
            $clientContainer = $container->register(CacheContainer::class);
            $container
                ->register(CacheDeleteCommand::class)
                ->setAutowired(true)
                ->addTag('console.command', ['command' => 'issetbv:cache:delete']);
            $container
                ->register(CacheFlushAllCommand::class)
                ->setAutowired(true)
                ->addTag('console.command', ['command' => 'issetbv:cache:flush-all']);
            $container
                ->register(CacheGetCommand::class)
                ->setAutowired(true)
                ->addTag('console.command', ['command' => 'issetbv:cache:get']);
            $container
                ->register(CacheSetCommand::class)
                ->setAutowired(true)
                ->addTag('console.command', ['command' => 'issetbv:cache:set']);
        }

        if (array_key_exists('redis', $config)) {
            foreach ($config['redis'] as $name => $data) {
                $id = 'issetbv_cache_redis_' . $name;
                $definition = $container->register($id, $data['driver']);
                $definition->setArgument('$host', $data['host']);
                $definition->setArgument('$port', $data['port']);
                $definition->setArgument('$persistent', $data['persistent']);

                if ($data['lazy']) {
                    $definition->setLazy(true);
                }

                if ($config['default'] === $name) {
                    $container->setAlias(CacheInterface::class, $id);
                }

                if (null !== $clientContainer) {
                    $clientContainer->addMethodCall(
                        'add',
                        ['$name' => $name, '$cacheClient' => new Reference($id)]
                    );
                }
            }
        }
    }
}
