<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service;

interface CacheInterface
{
    /**
     * Check if a key exists in the cache.
     *
     * @param string $key
     *
     * @return bool
     */
    public function exists(string $key): bool;

    /**
     * Get a key out of the cache.
     *
     * @param string $key
     *
     * @return mixed
     */
    public function get(string $key);

    /**
     * Get multiple keys out of the cache at once.
     *
     * @param string[] $keys array of string keys
     *
     * @return array key value pair of the given keys. key has a NULL if not in cache
     */
    public function getMulti(array $keys): array;

    /**
     * Set a key to a value.
     *
     * @param string $key
     * @param string $value
     */
    public function set(string $key, string $value);

    /**
     * Set a key to delete itself after the given seconds.
     *
     * @param string $key
     * @param int $seconds
     */
    public function expireSeconds(string $key, int $seconds);

    /**
     * Set a key to delete itself when the given timestamp is reached.
     *
     * @param string $key
     * @param int $timestamp
     */
    public function expireTimestamp(string $key, int $timestamp);

    /**
     * Set the key value pair to the cache.
     *
     * @param array $keys
     */
    public function setMulti(array $keys);

    /**
     * Delete the given key.
     *
     * @param string $key
     */
    public function delete(string $key);

    /**
     * Flush the whole cache.
     */
    public function flush();
}
