<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\CacheContainer;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CacheDeleteCommand extends ContainerAwareCommand
{
    /**
     * @var CacheContainer
     */
    private $cacheClientContainer;

    public function __construct(string $name = null, CacheContainer $cacheClientContainer)
    {
        parent::__construct($name);
        $this->cacheClientContainer = $cacheClientContainer;
    }

    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->addArgument(
            'cache',
            InputArgument::REQUIRED,
            'Cache to use'
        );
        $this->addArgument(
            'key',
            InputArgument::REQUIRED,
            'cache key to get'
        );
        $this->setDescription('Delete a cache item');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $client = $this->cacheClientContainer->getByName($input->getArgument('cache'));
        $client->delete($input->getArgument('key'));
    }
}
